/*jslint vars: true, plusplus: true, devel: true, browser: true, nomen: true, maxerr: 50 */
/*global $, document, transferKeyMessage, dismissInAppWalkthroughWindow, logDWMessage, updateSlide */
var NFW_HEADLIGHTS = {
    UT_NFW : "NFW",
    UT_NFW_VIDEO : "NFW_Video Watched "
};

var handleKeyupEvent = function (event) {
    "use strict";
    var KEYCODE_ESC = 27;
    //If Escape is pressed pass call the transferKeyMessage function
    switch (event.keyCode) {
    case KEYCODE_ESC:
        transferKeyMessage(event.keyCode);
        break;
    default:
        break;
    }
};

var preventNavigationIfNeeded = function (event) {
    "use strict";
    var KEYCODE_BACKSPACE = 8;
    if (event.keyCode === KEYCODE_BACKSPACE) {
        event.preventDefault();
        return false;
    }
};

var playVideo = function (event) {
	"use strict";
    var THUMBNAIL_CLASS = ".thumbnailContainer";
    var videoTag = $(event.target).attr('data-headlights');
    logDWMessage(NFW_HEADLIGHTS.UT_NFW, NFW_HEADLIGHTS.UT_NFW_VIDEO + videoTag);
    
    var videoURL = $(event.target).attr('data-url');
	$("#page_gallery").css({display: "none"});
	$("#player_screen").css({display: "block", opacity: 1});
	$('<iframe src="' + videoURL + '" width="620" height="480" frameborder="0" id="player" allowfullscreen></iframe>').insertBefore("#playerFooter");
};

var playVideoFromApp = function (uri) {
    "use strict";
	$("#page_gallery").css({display: "none"});
	$("#player_screen").css({display: "block", opacity: 1});
	$('<iframe src="' + uri + '" width="620" height="480" frameborder="0" id="player" allowfullscreen></iframe>').insertBefore("#playerFooter");
};

var stopAndDismissWindow = function () {
	"use strict";
	$("#player").remove();
	dismissInAppWalkthroughWindow();
};

var navFromPlayer = function () {
	"use strict";
	$("#player").remove();
	$("#player_screen").css({display: "none"});
	$("#page_gallery").css({display: "block", opacity: 1});
};

var initVideoStrings = function () {
    "use strict";
    $.i18n.properties({
        name: 'NfwOriginalStrings',
        language: ' ',
        path: 'strings/',
        mode: 'both',
        callback: function () {
            var locItems = $(".ToTranslate");
            var j = 0;
            for (j = 0; j < locItems.length; j++) {
                var nKey = locItems[j].getAttribute("data-id");
                locItems[j].innerHTML = jQuery.i18n.prop(nKey);
            }
        }
    });
};

var initVideoPage = function () {
    "use strict";
    document.addEventListener("keyup", handleKeyupEvent);
    document.addEventListener("keydown", preventNavigationIfNeeded, true);
    initVideoStrings();

    var url = window.location.href;
    var index = 0;
    var arr = url.split("?");
    
    if (arr.length === 2) {
        playVideoFromApp(arr[1]);
        return;
    }
};

var initUI = function () {
    "use strict";
    updateSlide(-1);
    return;
};

var getConnectionStatus = function (isConnected) {
    "use strict";
    if (isConnected) {
        $(".internetMessage").css({ display: "none" });
    }
};
	
$(".exitChoiceButton").click(navFromPlayer);
$(".playButton").click(playVideo);
